<?php
/**
* @version $Id: admin.fixusers.php 2008-06-24 18:17:00Z stell $
* @copyright Copyright (C) 2008 B01. www.bohacek.de. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// no direct access
defined( '_VALID_MOS' ) or die( 'Restricted access' );

if (!$acl->acl_check( 'administration', 'manage', 'users', $my->usertype, 'components', 'com_users' )) {
	mosRedirect( 'index2.php', _NOT_AUTH );
}

require_once( $mainframe->getPath( 'admin_html' ) );

$cid = josGetArrayInts( 'cid' );

switch ($task) {

	case 'fix':
		fixUsers( $cid, $option );
		break;

	case 'fixall':
		fixAllUsers( $option );
		break;
	
	case 'remove':
		remove( $cid, $option );
		break;

	default:
		showUsers( $option );
		break;
}

function showUsers( $option ) {
	global $database, $mainframe, $my, $acl, $mosConfig_list_limit;

	$filter_broken	=  $mainframe->getUserStateFromRequest( "filter_broken{$option}", 'filter_broken', 0 );
	$limit 			= intval( $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit ) );
	$limitstart 	= intval( $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 ) );
	$where 			= array();

	// exclude any child group id's for this user
	$pgids = $acl->get_group_children( $my->gid, 'ARO', 'RECURSE' );

	mosArrayToInts( $pgids );
	if (is_array( $pgids ) && count( $pgids ) > 0) {
		$where[] = '( a.gid != '  . implode( ' OR a.gid != ', $pgids ) . ' )';
	}

	if ( $filter_broken == 1 ) {
		$where[] = " g.name IS NULL ";
	}
	
	$query = "SELECT COUNT(a.id)"
	. "\n FROM #__users AS a";
	
	$query .= ( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : '' )
	;
	$database->setQuery( $query );
	$total = $database->loadResult();

	require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
	$pageNav = new mosPageNav( $total, $limitstart, $limit  );

	$query = "SELECT a.*, g.name AS groupname"
	. "\n FROM #__users AS a"
	. "\n LEFT JOIN #__core_acl_aro AS aro ON aro.value = a.id"	// map user to aro
	. "\n LEFT JOIN #__core_acl_groups_aro_map AS gm ON gm.aro_id = aro.aro_id"	// map aro to group
	. "\n LEFT JOIN #__core_acl_aro_groups AS g ON g.group_id = gm.group_id";

	$query .= (count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "")
	. "\n GROUP BY a.id"
	;
	
	$database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
	$rows = $database->loadObjectList();

	if ($database->getErrorNum()) {
		echo $database->stderr();
		return false;
	}

	$template = 'SELECT COUNT(s.userid) FROM #__session AS s WHERE s.userid = ';
	$n = count( $rows );
	for ($i = 0; $i < $n; $i++) {
		$row = &$rows[$i];
		$query = $template . (int) $row->id;
		$database->setQuery( $query );
		$row->loggedin = $database->loadResult();
	}

	// get list of Log Status for dropdown filter
	$broken[] = mosHTML::makeOption( 0, '- Select Usertable Status - ');
	$broken[] = mosHTML::makeOption( 1, 'Broken');
	$lists['broken'] = mosHTML::selectList( $broken, 'filter_broken', 'class="inputbox" size="1" onchange="document.adminForm.submit( );"', 'value', 'text', "$filter_broken" );
	
	
	HTML_users::showUsers( $rows, $pageNav, $search, $option, $lists );
}

function remove( $cid, $option ) {
	global $database, $acl, $my;

	if (!is_array( $cid ) || count( $cid ) < 1) {
		echo "<script> alert('Select an item to delete'); window.history.go(-1);</script>\n";
		exit;
	}

	if ( count( $cid ) ) {
		$obj = new mosUser( $database );		
		$removed_count = 0;
		foreach ($cid as $id) {
			$obj->load( $id );
			
			// delete user
			$obj->delete( $id );
			$msg = $obj->getError();
			
			$removed_count++;
		}
		$msg = $removed_count . " out of " . count($cid) . " users removed";
	}

	mosRedirect( 'index2.php?option='. $option, $msg );
}

function fixUsers( $cid, $option ) {
	global $database, $acl, $my;
	
	josSpoofCheck();

	if (!is_array( $cid ) || count( $cid ) < 1) {
		echo "<script> alert('Select an item to delete'); window.history.go(-1);</script>\n";
		exit;
	}

	if ( count( $cid ) )  {
		$section_value = 'users'; 
		$fixed_count = 0;
		
		$obj = new mosUser( $database );
		foreach ($cid as $id) {
			$obj->load( $id );
			$groups = $acl->get_object_groups( $section_value, $obj->id, 'ARO' ); 
			if(!count($groups)) {
				$acl->add_object( $section_value, $database->getEscaped( $obj->name ), $obj->id, null, null, 'ARO' );
				$acl->add_group_object( $obj->gid, $section_value, $obj->id, 'ARO' ); 	
				$fixed_count++;
			}
		}		
		
		$msg = $fixed_count . " out of " . count($cid) . " users fixed";
	}
	
	mosRedirect( 'index2.php?option='. $option, $msg );
}

function fixAllUsers( $option ) {
	global $database, $acl, $my;
	
	josSpoofCheck();

	$query = "SELECT a.id"
	. "\n FROM #__users AS a"
	. "\n LEFT JOIN #__core_acl_aro AS aro ON aro.value = a.id"	// map user to aro
	. "\n LEFT JOIN #__core_acl_groups_aro_map AS gm ON gm.aro_id = aro.aro_id"	// map aro to group
	. "\n LEFT JOIN #__core_acl_aro_groups AS g ON g.group_id = gm.group_id"
	. "\n WHERE g.name IS NULL ";
	
	$database->setQuery( $query );
	$cid = $database->loadResultArray();
	
	if ( count( $cid ) )  {
		$section_value = 'users'; 
		$fixed_count = 0;
		$obj = new mosUser( $database );
		foreach ($cid as $id) {
			$obj->load( $id );
			$groups = $acl->get_object_groups( $section_value, $obj->id, 'ARO' ); 
			if(!count($groups)) {
				$acl->add_object( $section_value, $database->getEscaped( $obj->name ), $obj->id, null, null, 'ARO' );
				$acl->add_group_object( $obj->gid, $section_value, $obj->id, 'ARO' ); 	
				$fixed_count++;
			}
		}
		$msg = $fixed_count . " out of " . count($cid) . " users fixed";
	}
	else {
		$msg = "No users need to be fixed";
	}
	
	mosRedirect( 'index2.php?option='. $option, $msg );
}
?>
