<?php
/**
* @copyright (C) 2010 B01 - Tom Bohacek
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );
require_once (JPATH_SITE.DS.'components'.DS.'com_quickfaq'.DS.'helpers'.DS.'route.php');

/**
 * QuickFAQ Content tag links plugin
 *
 */
class  plgContentQuickFaqTaglinks extends JPlugin
{
	/**
	 * Constructor
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @access	protected
	 * @param	object	$subject The object to observe
	 * @param 	array   $config  An array that holds the plugin configuration
	 * @since	1.5
	 */
	function plgContentQuickFaqTaglinks(& $subject, $config) {
		parent::__construct($subject, $config);
	}

	function onPrepareContent( &$article, &$params, $limitstart ) {

		// we check if QuickFaq is installed and enabled
		// wir berprfen, ob QuickFaq installiert und aktiviert ist
		if(!JComponentHelper::isEnabled('com_quickfaq', true)) {
			return true;
		}
	
		// we check if it is a request for printing articel
		// wir berprfen, ob es sich um den Aufruf der Druckansicht eines Artikels handelt
		if (JRequest::getBool('print')) {
			return true;
		}

		// we get the name of the actual performed component
		// wir holen uns den Namen der aktuell verwendeten Komponente
		global $option;
		
		// Get Plugin info
		// wir holen uns die Einstellungen des Plugins
		$plugin		=& JPluginHelper::getPlugin('content', 'quickfaqtaglinks');
		$plgParams	= new JParameter( $plugin->params );

		// we check if the actual component is the Joomla content component
		// wir berprfen, ob die aktuelle Komponente die Joomla Beitrge-Komponente ist
		if('com_content' == $option) {

			// we get the views for wich our plugin has to work
			// wir ermitteln Ansichten, in denen unser Plugin aktiv sein soll
			$onArticle = $plgParams->get('article', 1);
			$onBlog = $plgParams->get('blog', 1);
			$onFrontpage = $plgParams->get('frontpage', 1);
			
			// we read wich view and layout should be shown
			// wir ermitteln View und Layout, welche angezeigt werden soll
			$view = JRequest::getString('view');
			$layout = JRequest::getString('layout');
	
			// check if it isn't an article layout
			// wir prfen, ob fr welche Ansicht bzw. Layout unser Plugin aktiviert ist
			if ((($view == 'article') AND !$onArticle) OR (($layout == 'blog') AND !$onBlog) OR (($view == 'frontpage') AND !$onFrontpage)) {
				return true;
			}
		}
		// we check if the plugin is activ for other components wich fire the event 'onPrepareContent'
		// wir prfen ob unser Plugin bei anderen Komponenten aktiv sein soll, die das Ereignis 'onPrepareContent' auslsen
		else if($plgParams->get('onlycomcontent', 1)) {
			return true;
		}

		// we load the language data of our plugin und QuickFaq
		// wir binden die Sprachdateien fr unser Plugin und QuickFaq ein
		JPlugin::loadLanguage( 'plg_content_quickfaqtaglinks', JPATH_BASE.DS.'administrator');

		$db =& JFactory::getDBO();
		$t = $db->nameQuote('t');
		$tir = $db->nameQuote('tir');
		
		// We get all tags wich are assigned to at least one faq item.
		// Wir holen uns alle Tags, die mindestens einem FAQ-Artikel zu geordnent sind.
		$query = 'SELECT '.$t.'.'.$db->nameQuote('id').', '.$t.'.'.$db->nameQuote('name')
			.', CASE WHEN CHAR_LENGTH(t.alias) THEN CONCAT_WS(\':\', t.id, t.alias) ELSE t.id END as slug' 
			.' FROM '.$db->nameQuote('#__quickfaq_tags').' AS '.$t
			.' RIGHT JOIN '.$db->nameQuote('#__quickfaq_tags_item_relations').' AS '.$tir
			.' ON '.$t.'.'.$db->nameQuote('id').' = '.$tir.'.'.$db->nameQuote('tid')
			.' GROUP BY '.$t.'.'.$db->nameQuote('id')
		;
		$db->setQuery($query);
		$tags = $db->loadObjectList();

		$searchpattern = array();
		$replace = array();

		// go over all existing tags of QuickFaq
		// alle in QuickFaq vorhandenen Tags/Stichworte durchlaufen
		foreach($tags AS $i => $actTag) {
		
			// link mit hilfe des quickfaq routerhelpers zusammenbauen 
			// (der kmmert sich auch um die aktuelle itemid)
			$target = !$plgParams->get('opennewtab', 1) ? '' : 'target="_blank"';
			$url = JRoute::_(QuickfaqHelperRoute::getTagRoute($actTag->slug));		
			$title = JText::_('FAQ').' '.JText::_('ITEMS WITH TAG').' &quot;'.$actTag->name.'&quot;';		
			$htmlTag = '<a href="'. $url .'" '.$target.' title="'.$title.'">\0</a>';
		
			// search pattern is the word with no case sensitive '/i'
			// das Suchmuster ist das Wort des Tagnamens, wobei Gro-/Kleinschreibung ignoriert wird '/i'
			
			/* $searchpattern[] = '/\b'.$actTag->name.'\b(?!([^<]+)?>)/i'; */
			$searchpattern[] = '/(?!(?:[^<]+>|[^>]+<\/(a|h[1-9])>))\b'.$actTag->name.'\b/i';
			
			// replace value for found faq tags use the link to the tags view
			// definieren fr die Ersetzung gefundener Tags/Stichworte einen Link zur
			// Auflistung der mit diesem Tag innerhalb von QuickFaq verknpften Eintrge
			$replace[] = str_replace('[TAGID]', $actTag->id, $htmlTag);
		}

		// check if only the first place of finding should be linked to QuickFaq
		// alle oder nur ein tag ersetzen
		$limit = $plgParams->get('multilinks', 1) ? -1 : 1;
		
		// execute the replace function
		// Ersetzungsfunktion ausfhren
		$article->text = preg_replace($searchpattern, $replace, $article->text, $limit);

		return true;
	}
}